/*
 * ModificacioClient.java
 *
 * Created on 8 de junio de 2008, 0:48
 */

package actions;

import entitats.Client;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionForward;
/**
 *
 * @author Administrador
 * @version
 */

public class ModificacioClient extends Action {
    
    DataSource ds = null;
    Connection con = null;   
    
    public ActionForward execute(ActionMapping mapping, ActionForm  form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        
       Client client = (Client) form;
        
        try{
            ds = this.getDataSource(request);
            con = ds.getConnection();
            Statement st = con.createStatement();
            PreparedStatement sentencia = null;
            String sql = "";
            
            if (client.getIdClient() == 0)
            {
                client.setError("<font color='red'>Has d'escollir un client</font>");
                return mapping.findForward("ok");
            }
            
            //Comprovem si el client sera una empresa o una persona miran't si el cognom esta omplert o no
            if (client.getCognoms().equals(""))
                client.setTipus("empresa");
            else
                client.setTipus("persona");
            
            //Introduiexen les modificacions del usuari a la base de dades
            if (request.getSession().getAttribute("usuariagent") != null)
                sql = "UPDATE clients SET nif = ?, nom_o_rao_social = ?, cognoms = ?, telefon = ?, adresa = ?, tipus = ? WHERE id = "+client.getIdClient();
            else if (request.getSession().getAttribute("usuarivenedor") != null)          
                sql = "UPDATE clients SET nif = ?, nom_o_rao_social = ?, cognoms = ?, telefon = ?, adresa = ?, tipus = ?, preferencies_tipus_local = ?, preferencies_id_zona = ?, preferencies_superficie_minima = ? WHERE id = "+client.getIdClient();
            sentencia = con.prepareStatement(sql);
            sentencia.setString(1, client.getNif());
            sentencia.setString(2, client.getNom());
            sentencia.setString(3, client.getCognoms());
            sentencia.setString(4, client.getTelefon());
            sentencia.setString(5, client.getAdresa());
            sentencia.setString(6, client.getTipus());
            if (request.getSession().getAttribute("usuarivenedor") != null)
            {
                sentencia.setString(7, client.getTipusLocal());
                sentencia.setInt(8, client.getIdZona());
                sentencia.setFloat(9, client.getSuperficieMinima());
            }
            sentencia.executeUpdate();
            sentencia.close();
            
            if (request.getSession().getAttribute("usuarivenedor") != null)
            {
                //UPDATE DE LES PREFERENCIES DEL LLOGATER
                //sentencia = con.prepareStatement()
                client.setError("<font color='blue'>Llogater modificat satisfactoriament</font>");
                return mapping.findForward("ok");
            }
            
            client.setError("<font color='blue'>Propietari modificat satisfactoriament</font>");
            return mapping.findForward("ok");
            
        }catch(Exception excepcio){
            client.setError("<font color='red'>Excepcio ocorreguda en actions.modificacioClient:<br>" +
                    ""+excepcio.getMessage()+"</font>");
            
        } finally {
            try {
                if (con != null ) {
                    con.close();
                }
            } catch (Exception excepcio){
                client.setError("<font color='red'>Excepcio ocorreguda en actions.modificacioClient:<br>" +
                        ""+excepcio.getMessage()+"</font>");
                return mapping.findForward("ok");
            }
        }
        return mapping.findForward("ok");
    }
}
